/*
 * site_writePotential_delphi.cpp
 *
 *  Created on: Feb 26, 2014
 *      Author: chuan
 */

#include "site.h"

void CSite::writePotential_delphi()
{  // OLD CODE for writing (.phi) fromat delphi phimap, which does not
   // conform to specifications of .phi format. Therefore, being commented out
   // new code confroming to standard is being provided.
   // SHAILESH: JAN 14, 2020
   /*
   cout << "\nwriting potential map in DELPHI format\n\n";
   cout << "potential map written to file " << strPhiFile << endl << endl;

   char nxtlbl[10],head[21] = "now starting phimap ",tail[16] = " end of phimap ";
   delphi_real scalesingle = fScale;
   SGrid<delphi_real> oldmidsingle = fgBoxCenter;
   delphi_integer igrid = iGrid;

   ofstream ofPhiStream(strPhiFile.c_str(),ios::binary);

   if (bOutCrgDensity && (0 != fIonStrength))
      strcpy(nxtlbl,"concentrat");
   else
      strcpy(nxtlbl,"potential ");

   ofPhiStream.write(head,21);
   ofPhiStream.write(nxtlbl,10);
   ofPhiStream.write(rgcFileMap,54);
   {
      delphi_real* prgfData = prgfPhiMap.data();

      for (vector<delphi_real>::iterator it = prgfPhiMap.begin(); it != prgfPhiMap.end(); ++it)
      {
         ofPhiStream.write(reinterpret_cast<char*>(prgfData),sizeof(delphi_real));
         //ofPhiStream.write((&prgfData),sizeof(delphi_real));
         prgfData++;
      }
   }
   ofPhiStream.write(tail,16);
   ofPhiStream.write(reinterpret_cast<char*>(&scalesingle),sizeof(delphi_real));
   ofPhiStream.write(reinterpret_cast<char*>(&oldmidsingle),sizeof(SGrid<delphi_real>));
   ofPhiStream.write(reinterpret_cast<char*>(&igrid),sizeof(delphi_real));

   ofPhiStream.close();
   */


    cout << "\nwriting potential map in DELPHI format\n\n";
    cout << "potential map written to file " << strPhiFile << endl << endl;
    int32_t recordSize=0;
    char nxtlbl[10],head[20] = "now starting phimap",tail[16] = " end of phimap";
    delphi_real scalesingle = fScale;
    SGrid<delphi_real> oldmidsingle = fgBoxCenter;
    delphi_integer igrid = iGrid;
    //cout << "writePotential_delphi>> iGrid=" << iGrid << endl;
    ofstream ofPhiStream(strPhiFile.c_str(),ios::binary);
    recordSize = 10 + 20 + 60 + (4 * (igrid * igrid * igrid)) + 16 + (4 * 4);
    if (bOutCrgDensity && (0 != fIonStrength))
       strcpy(nxtlbl,"concentrt");
    else
       strcpy(nxtlbl,"potential");

    int32_t uplblSize = 20;
    ofPhiStream.write(reinterpret_cast<char*>(&uplblSize),sizeof(int32_t)); //fortran uplbl size begin
    ofPhiStream.write(head,20);
    ofPhiStream.write(reinterpret_cast<char*>(&uplblSize),sizeof(int32_t)); //fortran uplbl size end
    int32_t morelabelsSize = 10 + 60;
    ofPhiStream.write(reinterpret_cast<char*>(&morelabelsSize),sizeof(int32_t)); //fortran morelabels size begin
    ofPhiStream.write(nxtlbl,10);
    ofPhiStream.write(rgcFileMap,60);
    ofPhiStream.write(reinterpret_cast<char*>(&morelabelsSize),sizeof(int32_t)); //fortran morelabels size end
    {
       delphi_real* prgfData = prgfPhiMap.data();
       int32_t dataRecordSize = (4 * (igrid * igrid * igrid));
       ofPhiStream.write(reinterpret_cast<char*>(&dataRecordSize),sizeof(int32_t));
       float datavalue=0.0;
       int32_t ijk_to_1d_index = 0;
       int32_t igrid_square = igrid * igrid;
       for (int i = 0; i < igrid; i++)
       {
           for (int j = 0; j < igrid; j++)
           {
               for (int k = 0; k < igrid; k++)
               {   ijk_to_1d_index = i * igrid_square + j *igrid + k;
                   datavalue = (float) prgfPhiMap[ijk_to_1d_index];
                   ofPhiStream.write(reinterpret_cast<char*>(&datavalue),sizeof(datavalue));
               }
           }
       }
       ofPhiStream.write(reinterpret_cast<char*>(&dataRecordSize),sizeof(int32_t));
    }
    int32_t botlblSize = 16;
    ofPhiStream.write(reinterpret_cast<char*>(&botlblSize),sizeof(int32_t)); //fortran botlbl size begin
    ofPhiStream.write(tail,16);
    ofPhiStream.write(reinterpret_cast<char*>(&botlblSize),sizeof(int32_t)); //fortran botlbl size end
    float fscale, foldmidX, foldmidY, foldmidZ;
    fscale = (float)scalesingle;
    foldmidX = (float)oldmidsingle.nX;
    foldmidY = (float)oldmidsingle.nY;
    foldmidZ = (float)oldmidsingle.nZ;

    int32_t paramRecordSize = 20;
    ofPhiStream.write(reinterpret_cast<char*>(&paramRecordSize),sizeof(int32_t)); // fortran param size begin
    ofPhiStream.write(reinterpret_cast<char*>(&fscale),sizeof(float));   // 4-byte
    ofPhiStream.write(reinterpret_cast<char*>(&foldmidX),sizeof(float)); // 4-byte
    ofPhiStream.write(reinterpret_cast<char*>(&foldmidY),sizeof(float)); // 4-byte
    ofPhiStream.write(reinterpret_cast<char*>(&foldmidZ),sizeof(float)); // 4-byte
    ofPhiStream.write(reinterpret_cast<char*>(&igrid),sizeof(int32_t)); // 4-byte; total: 20-byte
    ofPhiStream.write(reinterpret_cast<char*>(&paramRecordSize),sizeof(int32_t)); // fortran param size end
    ofPhiStream.close();
}
