/*
 * ARGO
 */

#ifndef MISC_OVERLAPGAUSSIAN_
#define MISC_OVERLAPGAUSSIAN_

#include <set>
#include <vector>
#include "../delphi/delphi_constants.h"
#include "../misc/misc_grid.h"

using namespace std;


class OverlapRegion {
public:
	int Order;
	vector<int> Atoms;
	
	SGrid<delphi_real> r;

	delphi_real Alpha;
	delphi_real P;
	delphi_real  SumLambda;
	delphi_real Volume;
	delphi_real Radii_derivative;

	//constructor
	OverlapRegion();

	//overloaded constructor
	OverlapRegion(delphi_real& K, int& atom_idx, delphi_real Radius, delphi_real Rmsf, SGrid<delphi_real>& center);

	//destructor
	~OverlapRegion();


};

class BiGrid {
public:
	int aidx1;
	int aidx2;

	//constructor
	BiGrid();
//     BiGrid( int&,  int&);
    BiGrid(int, int);

	//destructor
	~BiGrid();
    
    //less
    const bool operator<(const BiGrid& other) const {

        if ( this->aidx1 < other.aidx1 ) {
            return true;
        } else if (( this->aidx1 == other.aidx1 ) && (this->aidx2 < other.aidx2) ) {
            return true;
        } else {
            return false;
        }
    }
    
    // more
    const bool operator>(const BiGrid& other) const {
       if ( this->aidx1 > other.aidx1 ) {
            return true;
        } else if (( this->aidx1 == other.aidx1 ) && (this->aidx2 > other.aidx2) ) {
            return true;
        } else {
            return false;
        }
    }
    
    //equal
    const bool operator==( BiGrid& other) const {
        return ((this->aidx1 == other.aidx1) && (this->aidx2 == other.aidx2));
    }
    
    const void print_BiGrid() const {
        cout << " BiGrid : " << aidx1 << ", " << aidx2 << endl;
        return;
    }
};

/*
class BiGrid_Node {
public:
    BiGrid data;
    BiGrid_Node * Left;
    BiGrid_Node * Right;
    
    //constructor
    BiGrid_Node();
    BiGrid_Node(BiGrid, BiGrid_Node* , BiGrid_Node*);
    
    //destructor
    ~BiGrid_Node();
};

class BST {
    //Binary Search Tree
public:
    BiGrid_Node * Root;
    int numNodes;
    vector<BiGrid> OverlapPairs;
    
    //constructor
    BST();
    BST(BiGrid_Node * root);
    
    //destructor
    ~BST();
    
    // push a bigrid_node into the tree
    void Push(BiGrid_Node * ptr_bg );
    
    // the actual function that inserts the biGrid_node recursively
    void _Insert(BiGrid_Node * Node, BiGrid_Node * ptr_bg);
    
    // do a postfix traversal of the tree and return elements in that order.
    // i.e. Left -> Right -> Parent
    // returns a pointer to the Bigrid_nodes in the BT
    void Traverse_PostFix();
    
    void _PostFix(BiGrid_Node * Node);
        
};
*/

#endif /* MISC_OVERLAPGAUSSIAN_ */
