/*
 * io_ambertraj.h
 *
 *  Created on: Apr 18, 2019
 *      Author: Shailesh
 */
#ifndef IO_NCAMBER_H
#define IO_NCAMBER_H

#include "io.h"
#include "io_ncbase.h"

#include <vector>
#ifdef ENABLE_TRAJECTORY_NC
#define DIM 3    // number of coordinate dimensions

using namespace std;

class CNCAmberTraj: public CNetcdfBase {
public:
    CNCAmberTraj() {

    }
    CNCAmberTraj(string intrajfilename) {
        trajfilename = intrajfilename;

    }
    //-----------------------------------------------------------------------//
    bool shouldRecordFrame(int &iFrameCurrent, const int &iFrameFirst, const int &iFrameLast, const int &iFrameStride) {
        bool retFlag = ((iFrameCurrent - iFrameFirst) % iFrameStride == 0 && iFrameCurrent >= iFrameFirst && iFrameCurrent <= iFrameLast);
        return retFlag;
    }
    int
    setupRead(CIO::SPrmtopHeadPointers &prmtopHeadPointer);
    delphi_integer
    readAmberNC(CIO::SPrmtopHeadPointers prmtopHeadPointer, vector<CFrame> &vctOfFrames, vector<delphi_real> &vctAtomRadii, const int &iFrameFirst,
                    const int &iFrameLast, const int &iFrameStride);
    void NC_close() {
        CNetcdfBase::NC_close();
    }
private:
    string trajfilename;
};

#endif
#endif // end block if nc is enabled
