#ifndef DDM__ALGORITHM_H_
#define DDM__ALGORITHM_H_

/**
 * \defgroup  DDMAlgorithms  Algorithms operating on DDM containers
 *
 * \par Description
 *
 * DDM algorithms library defines functions for a variety of purposes 
 * (e.g. searching, sorting, counting, manipulating) that operate on DDM containers.
 *
 */

#include "../ddm/algorithm/Operation.h"
#include "../ddm/algorithm/LocalRange.h"
#include "../ddm/algorithm/ForEach.h"
#include "../ddm/algorithm/MinMax.h"
#include "../ddm/algorithm/Transform.h"
#include "../ddm/algorithm/Accumulate.h"
#include "../ddm/algorithm/Copy.h"
#include "../ddm/algorithm/Fill.h"
#include "../ddm/algorithm/Generate.h"
#include "../ddm/algorithm/AllOf.h"
#include "../ddm/algorithm/AnyOf.h"
#include "../ddm/algorithm/Find.h"
#include "../ddm/algorithm/Equal.h"

#include "../ddm/algorithm/SUMMA.h"

#endif // DDM__ALGORITHM_H_
