
#include "../misc/misc_overlapGaussian.h"
#include "../misc/misc_grid.h"
#include "../delphi/delphi_constants.h"
#include <iostream>
#include <iomanip>
#include <vector>
#include <math.h>

using namespace std;


OverlapRegion::OverlapRegion() {
	//default
	Order = 0;
	Atoms = vector<int>();
	Volume = 0.;

	Alpha = 1.;
	SumLambda = 0.;
	r.nX = 0.;
	r.nY = 0.;
	r.nZ = 0.;
	P = 1.;
	Radii_derivative = 0.;

}

OverlapRegion::OverlapRegion(delphi_real& K, int& atom_idx, delphi_real Radius, delphi_real Rmsf, SGrid<delphi_real>& center) {
	Order = 1;
	Atoms = vector<int>(); Atoms.push_back(atom_idx);
	r.nX = center.nX;
	r.nY = center.nY;
	r.nZ = center.nZ;

	Radius += Rmsf;
	Alpha = K/pow(Radius,2);
	P = f4Pi * pow((K/fPi),1.5)/3.;
	
	SumLambda = 0.;
	Volume = f4Pi * pow(Radius,3)/3.;
	Radii_derivative = f4Pi * pow(Radius,2);
	
}

OverlapRegion::~OverlapRegion() {
	// Atoms.clear();
} 

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
BiGrid::BiGrid() {
	aidx1 = -1; aidx2 = -1;
}

//BiGrid::BiGrid( int& i1,  int& i2) {
//    aidx1 = i1; aidx2 = i2;
//}

BiGrid::BiGrid(int i1, int i2) {
    aidx1 = i1; aidx2 = i2;
}

BiGrid::~BiGrid() {}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
BiGrid_Node::BiGrid_Node() {
    data.aidx1 = -1;
    data.aidx2 = -1;
    Left = NULL;
    Right = NULL;
}

BiGrid_Node::BiGrid_Node(BiGrid bg, BiGrid_Node * leftChild, BiGrid_Node * rightChild) {
    data = bg;
    Left = leftChild;
    Right = rightChild;
}

BiGrid_Node::~BiGrid_Node() {}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BST::BST() {
    Root = nullptr;
    numNodes = 0;
    OverlapPairs.resize(0);
}

BST::BST(BiGrid_Node * root) {
    Root = root;
    numNodes = 1;
    OverlapPairs.push_back(Root->data);
}

BST::~BST() {
    Root = nullptr;
    numNodes = 0;
    OverlapPairs.clear();
}

void BST::Push(BiGrid_Node * ptr_bg) {
    _Insert(Root, ptr_bg);
    return;
}

void BST::_Insert(BiGrid_Node * Node, BiGrid_Node * ptr_bg) {
    
    // cout << Node->data.aidx1 << ", " << Node->data.aidx2 << " vs ";
    // cout << ptr_bg->data.aidx1 << ", " << ptr_bg->data.aidx2 << endl;
    
//    if ( (*Node).data > (*ptr_bg).data ) {
//        if ( Node->Left != nullptr ) {
//            _Insert(Node->Left, ptr_bg);
//        } else {
//            // cout << " Left is Null" << endl;
//            Node->Left = ptr_bg;
//            //OverlapPairs.push_back((*ptr_bg).data);
//            numNodes ++;
//            return;
//        }
//    }
//
//    if ( (*Node).data < (*ptr_bg).data ) {
//        if ( Node->Right != nullptr ) {
//            _Insert(Node->Right, ptr_bg);
//        } else {
//            // cout << " Right is Null" << endl;
//            Node->Right = ptr_bg;
//            //OverlapPairs.push_back((*ptr_bg).data);
//            numNodes++;
//        }
//        return;
//    }
    
    
}

void BST::Traverse_PostFix() {
    //clear the vector Nodes before filling it again
    //cout << " Traverse_PostFix >> clear the vector Nodes before filling it again" << endl;
    if (!OverlapPairs.empty())  OverlapPairs.resize(0);
    //cout << " Cleared ... " << endl;
    // cout << " Root : " << Root->data.aidx1 << ", " << Root->data.aidx2 << endl;

    _PostFix(Root);
    return;
}

void BST::_PostFix(BiGrid_Node * Node) {
    
    if ( Node == nullptr ) return;
    if ( Node->Left != nullptr ) {
        _PostFix(Node->Left);
    }
    
    if ( Node->Right != nullptr) {
        _PostFix(Node->Right);
    }
    
    OverlapPairs.push_back(Node->data);
    // cout << Node->data.aidx1 << ", " << Node->data.aidx2 << endl;
    return ;
    
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

*/

