/*
 * delphi_datamarshal_showTrajParameters.cpp
 *
 *  Created on: Feb 01, 2019
 *      Author: Arghya 
 */

#include "delphi_datamarshal.h"
#include <boost/lexical_cast.hpp>

void CDelphiDataMarshal::showTrajParameters() const
{
#ifdef ENABLE_TRAJECTORY
    cout << fixed; // set the floatfield format flag for the str stream to fixed
    cout << "   " << endl;

    size_t MAXWIDTH=45;
    std::string time_string = " Time>";


    cout << time_string << left << setw(MAXWIDTH) << " Read in and/or assign rad/chrg done at ";
    pTimer->showTime();
    cout << endl;

	// Trajectory information
	cout << left << setw(MAXWIDTH) << " Do Trajectory calculations? " << " : " << (bDoMMPBSA?"YES":"NO")  << endl;
	cout << left << setw(MAXWIDTH) << " Trajectory file " << " : " << strTrajFile << endl;
	cout << left << setw(MAXWIDTH) << " Topology file " << " : " << strTopolFile << endl;
    cout << left << setw(MAXWIDTH) << " Total number of frames read " << " : " << vctSimFrames.size() << endl; 	
    cout << left << setw(MAXWIDTH) << " Total number ofatoms in each frame " << " : " << iAtomNum << endl; 	
    
	if (bSolvePB)
    {
        cout << left << setw(MAXWIDTH) << " Outside dielectric" << " : " << fExDielec << endl;
        cout << left << setw(MAXWIDTH) << " Inside/reference  dielectric" << " : " << fInDielec << endl;


        cout << left << setw(MAXWIDTH) << " First kind salt [C] (M) " << " : " << vctfSalt[0] << endl;
        cout << left << setw(MAXWIDTH) << " Valences salt 1 are"      << " : " << vctiValence1[0] <<  right << setw(10) << vctiValence1[1] << endl;

        if(vctfSalt[1]!=0.0f)
        {
            cout << left << setw(MAXWIDTH) << " Second kind salt [C] (M) " << " : " << vctfSalt[1] << endl;
            cout << left << setw(MAXWIDTH) << " Valences salt 2 are"       << " : " << vctiValence2[0] <<  right << setw(10) << vctiValence2[1] << endl;
        }
        cout << left << setw(MAXWIDTH) << " Ionic strength (M)"        << " : " << fIonStrength << endl;
        cout << left << setw(MAXWIDTH) << " Debye length (A)"          << " : " << fDebyeLength << endl;
        cout << left << setw(MAXWIDTH) << " Absolute temperature (K)"  << " : " << fTemper      << endl;
        cout << left << setw(MAXWIDTH) << " Ion exclusion [r] (A)"    << " : " << fIonRadius   << endl;
        cout << left << setw(MAXWIDTH) << " Probe[r] facing water (A)" << " : " << vctfProbeRadius[0] << endl;
        cout << left << setw(MAXWIDTH) << " Probe[r] internal (A)" << " : " << vctfProbeRadius[1] << endl;

        switch (iBndyType)
        {
            case 1: cout << left << setw(MAXWIDTH) << " Boundary conditions" << " : " << "ZERO\n";         break;
            case 2: cout << left << setw(MAXWIDTH) << " Boundary conditions" << " : " << "DIPOLAR\n";      break;
            case 3: cout << left << setw(MAXWIDTH) << " Boundary conditions" << " : " << "FOCUSSING\n";    break;
            case 4: cout << left << setw(MAXWIDTH) << " Boundary conditions" << " : " << "COULOMBIC\n";    break;
            case 5: cout << left << setw(MAXWIDTH) << " Boundary conditions" << " : " << "VOLTAGE DROP\n"; break;
        }

        #ifdef VERBOSE
        cout << left << setw(MAXWIDTH) << " x,y,z PBC. and volt drop" << " : " << vctbPeriodicBndy[0] << right << setw(6) << vctbPeriodicBndy[1];

        if (vctbPeriodicBndy[3] || vctbPeriodicBndy[4] || vctbPeriodicBndy[5])
            cout << left << setw(MAXWIDTH) << " Voltage drops along x,y,z" << " : " << gfPotentialDrop.nX
            << right << setw(10) << gfPotentialDrop.nY
            << right << setw(10) << gfPotentialDrop.nZ << endl;
        #endif

        if (bAutoConverge)
        {
            if (0.0 < fGridConverge)
                cout << left << setw(MAXWIDTH) << " Convergence by grid energy" << " : " << fGridConverge << " kt\n";
            else
                cout << left << setw(MAXWIDTH) << " # of linear iterations" << " : " << "Automatic\n";
        }
        else
            cout << left << setw(MAXWIDTH) << " # of linear iterations" << " : " << iLinIterateNum << endl;

        if (0.0 < fRmsc || 0.0 < fMaxc)
        {
            cout << left << setw(MAXWIDTH) << " Convergence by rms change" << " : " << scientific << fRmsc << " kT\n";
            cout << left << setw(MAXWIDTH) << " Convergence by max change" << " : " << scientific << fMaxc << " kT\n";
        }

        if (fZero > fIonStrength && 0 < iNonIterateNum)
            cout << left << setw(MAXWIDTH) << " Ionic strength=0 ==> only linear iterations \n";
        else
        {
            cout << left << setw(MAXWIDTH) << " # of non-linear iterations" << " : " << iNonIterateNum << endl;
            cout << left << setw(MAXWIDTH) << " Non-linear energy calc."    << " : " << bNonlinearEng << endl;
            cout << left << setw(MAXWIDTH) << " Manual relaxation para."    << " : " << bManualRelaxParam << endl;
        }

        cout << left << setw(MAXWIDTH) << " GAUSSIAN module" <<  " : " << (iGaussian?"ON":"OFF") << endl;
        if ( iGaussian ) cout << left << setw(MAXWIDTH) << " GAUSSIAN sigma" <<  " : " << fSigma << endl;
        if ( iGaussian ) cout << left << setw(MAXWIDTH) << " GAUSSIAN surface cut off" <<  " : " << fSrfcut << endl;
        if ( iGaussian ) cout << left << setw(MAXWIDTH) << " GAUSSIAN power multiplier" <<  " : " << iGaussianPowerMult << endl;

        cout << left << setw(MAXWIDTH) << " Surface potential calculations" << " : " << (zetaOn?"ON":"OFF") << endl;
        if ( zetaOn ) cout << left << setw(MAXWIDTH) << " Surface requested at distance (A)"      <<  " : " << zetaDistance << endl;

        cout << left << setw(MAXWIDTH) << " Non-polar energy calculation" << " : " << (bNonPolEng?"ON":"OFF") << endl;
        if ( bNonPolEng ) cout << left << setw(MAXWIDTH) << " Radius offset value (A)"      <<  " : " << fRoffset << endl;
        if ( bNonPolEng ) cout << left << setw(MAXWIDTH) << " Constant for exponential term"      <<  " : " << fKexpConst << endl;
        if ( bNonPolEng ) cout << left << setw(MAXWIDTH) << " Solvent pressure coefficient"      <<  " : " << fPressureCoeff << endl;
		

        #ifdef VERBOSE
        cout << left << setw(MAXWIDTH) << " Ionic direct energy"      << " : " << bIonsEng << endl;
        cout << left << setw(MAXWIDTH) << " Concentration map output" << " : " << bOutCrgDensity << endl;
        cout << left << setw(MAXWIDTH) << " Spherical charge distbn." << " : " << bCrgInterplateType << endl;
        cout << left << setw(MAXWIDTH) << " INSIGHT format output"    << " : " << bBiosystemOut << endl;
        cout << left << setw(MAXWIDTH) << " Ionic direct energy"      << " : " << bSiteOut << endl;
        #endif

    } // ---------- end of if (bSolvePB)
#endif
}
