#!/bin/bash

dataset="vc"
platform="Cpu"
diel_model="D2"
implementation="Py"

gridtype="cubic"  # or "cuboidal"

case "$gridtype" in
    cubic)    gridtype_code="Cbc" ;;
    cuboidal) gridtype_code="Cbl" ;;
    *)        gridtype_code="???";;
esac

for runid in run01 run02 run03; do
    j=${runid/run/}
    for ncpu in 64 48 32 16 1; do
        jobname="${j}${dataset}${platform}${ncpu}${gridtype_code}${diel_model}${implementation}NlSOR"
        echo "Submitting job: $jobname"
        sbatch \
            --job-name="${jobname}" \
            --output="${jobname}_%j.out" \
            --error="${jobname}_%j.err" \
            --time=72:00:00 \
            --cpus-per-task=${ncpu} \
            --constraint=chip_type_8358 \
            --mem=172G \
            pydelphi_cpu_job.sh "$gridtype" "$ncpu" "$runid"
    done
done
