#!/bin/bash

dataset="pp46"
platform="Cpu"
implementation="Py"
gridtype="cubic"  # or "cuboidal"
diel_model="trad"   # or "trad", "gausscut"

# Short grid type tag
case "$gridtype" in
    cubic) gridtype_code="Cbc" ;;
    cuboidal) gridtype_code="Cbl" ;;
esac

# Short dielectric tag
case "$diel_model" in
    trad) diel_tag="D2" ;;
    gauss) diel_tag="Gsn" ;;
    gausscut) diel_tag="Gsc" ;;
esac

for runid in run01 run02 run03; do
    j=${runid/run/}
    for ncpu in 32 24 16 8 4 1; do
        jobname="${j}${dataset}${platform}${ncpu}${gridtype_code}${diel_tag}${implementation}"
        echo "Submitting job: $jobname"

        sbatch \
            --job-name="$jobname" \
            --output="${jobname}_%j.out" \
            --error="${jobname}_%j.err" \
            --time=72:00:00 \
            --cpus-per-task=${ncpu} \
            --constraint=chip_type_8358 \
            --mem=48G \
            pydelphi_cpu_job.sh "$gridtype" "$ncpu" "$diel_model" "$runid"
    done
done
