#!/bin/bash
#SBATCH --job-name=2pp46GpuD2Cbl
#SBATCH --output=2pp46GpuD2Cbl_%j.out
#SBATCH --error=2pp46GpuD2Cbl_%j.err
#SBATCH --time=24:00:00
#SBATCH --cpus-per-task=8
#SBATCH --mem=48G
#SBATCH --gres=gpu:a100:1         
#SBATCH --constraint=gpu_a100_80gb

module load anaconda3/2023.09-0
module load cuda/12.3.0

source $(conda info --base)/etc/profile.d/conda.sh
conda activate py312_pydelphi020

for runid in run01 run02 run03; do
    # --- Directory Check and Creation (with warning, then proceed) ---
    if [ -d "$runid" ]; then
        echo "Warning: Directory '$runid' already exists. Assuming it belongs to the same batch of runs and proceeding."
    else
        echo "Directory '$runid' does not exist. Creating it..."
        mkdir -p "$runid" # -p creates parent directories if they don't exist
        if [ $? -ne 0 ]; then
            echo "Error: Failed to create directory '$runid'. Aborting."
            exit 1 # Still abort if directory creation itself fails (e.g., permissions)
        fi
    fi
    # --- End Directory Check ---

    for pqr in $(cat ../pqr-file-list); do
        PDB=${pqr//.pqr/}
        pdb=${PDB,,}
        pdb=${pdb//_/-}
        echo "Processing $pdb"
        foutprefix=${runid}/${pdb}_trad-cbl-bxm15-gpu-nl-sor

        lscpu > ${foutprefix}-lscpu.txt
        cat /proc/cpuinfo > ${foutprefix}-cpuinfo.txt

        sed "s|__PQR_FILE__|${pqr}|g" prm.templates/trad-cuboidal-nl.prm > ${foutprefix}.prm

        # GPU runs
        timeout --kill-after=5m 45m /usr/bin/time -v pydelphi-static -p double -P cuda -t 1 -f ${foutprefix}.prm \
            -o ${foutprefix}-f8-cpu1.csv -l ${pdb} -v info -S -O \
            > ${foutprefix}-f8-cpu1.log 2>&1

        timeout --kill-after=5m 45m  /usr/bin/time -v pydelphi-static -p double -P cuda -t 8 -f ${foutprefix}.prm \
            -o ${foutprefix}-f8-cpu8.csv -l ${pdb} -v info -S -O \
            > ${foutprefix}-f8-cpu8.log 2>&1

        timeout --kill-after=5m 45m /usr/bin/time -v pydelphi-static -p single -P cuda -t 1 -f ${foutprefix}.prm \
            -o ${foutprefix}-f4-cpu1.csv -l ${pdb} -v info -S -O \
            > ${foutprefix}-f4-cpu1.log 2>&1

        timeout --kill-after=5m 45m  /usr/bin/time -v pydelphi-static -p single -P cuda -t 8 -f ${foutprefix}.prm \
            -o ${foutprefix}-f4-cpu8.csv -l ${pdb} -v info -S -O \
            > ${foutprefix}-f4-cpu8.log 2>&1
    done
done
