# pyDelphi Benchmarking Package
### Datasets and Scripts for Reproducing Manuscript Results

This archive contains the datasets and analysis scripts used in support of the manuscript:

**“Accurate and Scalable Continuum Electrostatics for Large Biomolecular Systems:  
The pyDelPhi Poisson–Boltzmann Framework”** *(manuscript in preparation)*

The **pyDelphi source code** is available separately on GitHub.

It provides the **input structures**, **parameter templates**, and **batch scripts** needed to reproduce the benchmarking calculations described in the paper.  **Output logs and map files are *not* included** to keep the archive size manageable.

---

## Contents

### **datasets/**
Curated PQR structures and run directories for all benchmark systems:

- **pm74** — 74 monomeric proteins  
- **pp46** — 46 protein–protein complexes  
- **pd66** — 66 protein–DNA complexes  
- **vc1** — Hepatitis B virus (HBV) capsid benchmark  

Each dataset subdirectory includes:
- PQR structures  
- DelPhi reference run params and scripts (`cpp-result-*`)  
- pyDelphi CPU/GPU run params and scripts (`py-result-*`)  
- Parameter templates (`prm.templates/`)  
- Batch scripts to reproduce all calculations  

---

## Software: Delphicpp-v8.5.0 (for reference runs)
A copy of Delphicpp-v8.5.0 with module-wise timing reporting enabled is provided in software directoy. Compile the serial and opm-parallel versions by running make in Relase and Release_omp folders. User may have to edit src/inteface/environment.h to enable omp via uncommenting line:
//#define PARALLEL_OMP

Also define the PROJECT_HOME environment variable pointing to this directory.

### **analysis-scripts/**
Jupyter notebooks for:
- Accuracy assessment  
- Runtime and solver speedups  
- Memory profiling  
- Log parsing and TSV report generation  

These notebooks were used to generate the accuracy plots, runtime scaling, and memory figures described in the manuscript.

Create the environment for analysis using:

```bash
conda env create -f py312_protprop_clean.yml
```
---

## Reproducing Calculations

Inside a dataset directory (e.g., `pd66/`):

### **Run pyDelphi**
CPU:
```bash
cd py-result-trad
bash run-all-cubic-cpu.sh
```

GPU:
```bash
cd py-result-trad/
sbatch run-all-cubic-gpu.sh
```

Nonlinear PB (SOR iterations):
```bash
cd py-result-trad-nl-sor
sbatch run-all-cubic-gpu.sh
```

Nonlinear PB (Newton iterations):
```bash
cd py-result-trad-nl-nwt
sbatch run-all-cubic-gpu.sh
```

Once all the runs in all directories are completed, proceed with analysis using scripts detailed above.


# Contact

For questions regarding this package, please contact:
Shailesh Kumar Panday, Clemson University (spanday@clemson.edu or shaileshp51@gmail.com)
